﻿var executeSQLActionResultEditor = {
    context: $(".v-executeSQLActionResultEditor"),
    variablesOnly: $("#VariablesOnly").val() == "True",
    initialize: function () {
        this.context = $(".v-executeSQLActionResultEditor");
        $(".v-conditionsTable tbody tr", this.context).each(function () {
            var row = $(this);
            var autoComplete = executeSQLActionResultEditor.setVariablesAutoComplete(row);
            var selectedItem = autoComplete.a4autocomplete("getValue");

            $(".h-conditionValueAutocomplete", row).change(function () {
                $(".v-conditionValue", row).val($(this).val());
            });
        });
    },
    bindEvents: function () {
        this.context.on("click", ".h-addConditionRow", function () {
            var table = $(".v-conditionsTable", executeSQLActionResultEditor.context);
            var row = $("tfoot .v-conditionRow", table).clone();
            var index = $("tbody tr", table).length;
            var modelName = table.attr("data-name");

            $("tbody", table).append(row);

            executeSQLActionResultEditor.toggleItemsVisibility();
            executeSQLActionResultEditor.setVariablesAutoComplete(row);
            executeSQLActionResultEditor.setConditionInputs(modelName, index, row);
        });

        $(".v-conditionsTable", this.context).on("click", ".h-deleteRow", function () {
            $(this).closest("tr").remove();

            executeSQLActionResultEditor.reindexConditionsTable();
            executeSQLActionResultEditor.toggleItemsVisibility();
        });

        $(".h-testSQLStatement").on("click", function () {
            var editor = $(".v-executeSQLActionEditor");
            a4.callServerMethod(a4.top().questionnaireEditor.getUrl("TestSQLQuery"), { connectionString: $(".v-executeSQLConnectionString", editor).val(), sql: $(".v-executeSQLStatement", editor).val() },
                    function (result) {
                        var message = "<div style='text-align:left'><div style='text-align:center'><b>" + executeSQLResources.SQLServerResult + "</b></div><br />";
                        if (result.length > 0) {
                            for (var propertyName in result[0])
                                message += "<b>" + propertyName + "</b> : " + result[0][propertyName] + "<br/>";
                            message += "</div>"
                        }
                        else
                            message += "<b>OK</b>";

                        a4.showSuccessMessage(message);

                    });
        });
    },
    reindexConditionsTable: function () {
        var table = $(".v-conditionsTable", this.context);
        var modelName = table.attr("data-name");

        $("tbody tr", table).each(function (index) {
            executeSQLActionResultEditor.setConditionInputs(modelName, index, $(this));
        });
    },
    setConditionInputs: function (modelName, index, row) {
        this.setConditionInputName(modelName, index, $(".h-conditionVariable", row));
        this.setConditionInputName(modelName, index, $(".v-conditionOperator", row));
        this.setConditionInputName(modelName, index, $(".v-conditionValue", row));
        this.setConditionInputName(modelName, index, $(".v-conditionIndex", row));

        $(".v-conditionIndex", row).val(index + 1);
        $(".v-index", row).text(index + 1);
    },
    setConditionInputName: function (modelName, index, input) {
        input.attr("name", modelName + "[" + index + "]." + input.attr("data-name"));
    },
    setVariablesAutoComplete: function (row) {
        return $(".h-conditionVariable", row).a4autocomplete({
            data: a4.top().questionnaireEditor.variables.sort(a4.top().questionnaireEditor.sortVariables),
            valueProperty: "value",
            labelProperty: "name",
            tooltipProperty: "questionId",
            tooltipData: function (autocomplete, tooltip, questionId) {
                a4.getTooltipQuestionText(autocomplete, tooltip, a4.top().questionnaireEditor.Id, questionId);
            }
        });
    },
    clearValuesAutoComplete: function (row) {
        $(".h-conditionValueAutocomplete", row).val("");
        $(".h-conditionValueAutocomplete", row).unbind("change");

        if ($(".h-conditionValueAutocomplete", row).hasClass("autocomplete")) {
            $(".h-conditionValueAutocomplete", row).a4autocomplete("destroy");
        }
    },
    setValuesAutoComplete: function (row, variable, isDiscreteVariable) {
        $(".h-conditionValueAutocomplete", row).a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetVariableChoices", "Shared"),
            ajaxParams: { variableName: variable },
            validateSelection: isDiscreteVariable,
            altValueField: $(".v-conditionValue", row)
        });
    },
    toggleItemsVisibility: function () {
        var table = $(".v-conditionsTable", this.context);
        var rowsCount = $("tbody tr", table).length;

        $(".v-conditionTypePanel", this.context).toggle(rowsCount > 1);
        $(".v-customConditionPanel", this.context).toggle(rowsCount > 1 && $(".h-conditionType", this.context).val() == "Custom");
        table.toggle(rowsCount > 0);
    },
    getExpression: function () {
        var conditionType = $(".h-conditionType", this.context).val();
        var customCondition = $(".v-customCondition", this.context).val();
        var conditions = $(".v-conditionsTable tbody .v-conditionRow", this.context).map(function () {
            return {
                Index: parseInt($(this).find(".v-conditionIndex").val()),
                VariableName: $(this).find(".h-conditionVariable").val(),
                Operator: $(this).find(".v-conditionOperator").val(),
                Value: $(this).find(".v-conditionValue").val()
            }
        }).get();

        return {
            ConditionType: conditionType,
            CustomCondition: customCondition,
            Conditions: conditions
        };
    }
}